/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWTime;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskField;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskMacros;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWDeadlinePanel
extends JPanel
implements ItemListener,
ActionListener,
DocumentListener,
IVWMapChangedListener {
    public static final int STEP = 1;
    public static final int WORKFLOW = 2;
    private int m_mode = 1;
    private VWStepDefinition m_stepDefinition = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMaskMacros m_macros = null;
    private VWMaskField m_deadlineTextField = null;
    private JComboBox m_deadlineUnitCBox = null;
    private VWMaskField m_reminderTextField = null;
    private JComboBox m_reminderUnitCBox = null;
    private GridBagConstraints m_gridBag = null;

    public VWDeadlinePanel(int mode) {
        this.m_mode = mode;
    }

    public void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_macros = new VWMaskMacros();
            this.m_macros.addMacro('#', "[0-9]");
            this.setLayout(new GridBagLayout());
            this.m_gridBag = new GridBagConstraints();
            this.m_gridBag.insets = new Insets(2, 2, 2, 2);
            this.initDeadlineControls();
            this.initReminderControls();
            this.m_authPropertyData = authPropertyData;
            if (this.m_mode == 2) {
                this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
                this.setWorkflow();
            } else {
                this.m_authPropertyData.getSelectionChangeEventNotifier().addItemListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        int stepType;
        Object item = null;
        if (event.getStateChange() != 1) {
            return;
        }
        item = event.getItem();
        if (item != null && item instanceof VWStepDefinition && VWStepUtils.isGeneralStep(stepType = VWStepUtils.getStepType((VWMapNode)item))) {
            this.setSelectedStep((VWStepDefinition)item);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_deadlineUnitCBox) {
            this.updateDeadlineDefinition();
        } else if (event.getSource() == this.m_reminderUnitCBox) {
            this.updateReminderDefinition();
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_deadlineTextField.getDocument()) {
            this.updateDeadlineDefinition();
        } else if (event.getDocument() == this.m_reminderTextField.getDocument()) {
            this.updateReminderDefinition();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_deadlineTextField.getDocument()) {
            this.updateDeadlineDefinition();
        } else if (event.getDocument() == this.m_reminderTextField.getDocument()) {
            this.updateReminderDefinition();
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 554: {
                this.setWorkflow();
            }
        }
    }

    private void initDeadlineControls() {
        try {
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 2;
            this.m_gridBag.gridx = 0;
            this.m_gridBag.gridy = 0;
            this.m_gridBag.weightx = 0.1;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.add((Component)new JLabel(VWResource.s_deadlineWithin), this.m_gridBag);
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 2;
            this.m_gridBag.gridx = 1;
            this.m_gridBag.gridy = 0;
            this.m_gridBag.weightx = 0.6;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.m_deadlineTextField = new VWMaskField("#####", this.m_macros, ' ');
            this.m_deadlineTextField.setText("0");
            this.add((Component)this.m_deadlineTextField, this.m_gridBag);
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 2;
            this.m_gridBag.gridx = 2;
            this.m_gridBag.gridy = 0;
            this.m_gridBag.weightx = 0.3;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.m_deadlineUnitCBox = new JComboBox();
            this.m_deadlineUnitCBox.addItem(VWResource.s_minutes);
            this.m_deadlineUnitCBox.addItem(VWResource.s_hours);
            this.m_deadlineUnitCBox.addItem(VWResource.s_days);
            this.m_deadlineUnitCBox.addItem(VWResource.s_weeks);
            this.add((Component)this.m_deadlineUnitCBox, this.m_gridBag);
            this.m_deadlineUnitCBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initReminderControls() {
        try {
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 2;
            this.m_gridBag.gridx = 0;
            this.m_gridBag.gridy = 1;
            this.m_gridBag.weightx = 0.1;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.add((Component)new JLabel(VWResource.s_sendReminder), this.m_gridBag);
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 2;
            this.m_gridBag.gridx = 1;
            this.m_gridBag.gridy = 1;
            this.m_gridBag.weightx = 0.6;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.m_reminderTextField = new VWMaskField("#####", this.m_macros, ' ');
            this.m_reminderTextField.setText("0");
            this.add((Component)this.m_reminderTextField, this.m_gridBag);
            this.m_reminderTextField.getDocument().addDocumentListener(this);
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 2;
            this.m_gridBag.gridx = 2;
            this.m_gridBag.gridy = 1;
            this.m_gridBag.weightx = 0.2;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.m_reminderUnitCBox = new JComboBox();
            this.m_reminderUnitCBox.addItem(VWResource.s_minutes);
            this.m_reminderUnitCBox.addItem(VWResource.s_hours);
            this.m_reminderUnitCBox.addItem(VWResource.s_days);
            this.m_reminderUnitCBox.addItem(VWResource.s_weeks);
            this.add((Component)this.m_reminderUnitCBox, this.m_gridBag);
            this.m_reminderUnitCBox.addActionListener(this);
            this.m_gridBag.anchor = 21;
            this.m_gridBag.fill = 0;
            this.m_gridBag.gridx = 3;
            this.m_gridBag.gridy = 1;
            this.m_gridBag.weightx = 0.1;
            this.m_gridBag.weighty = 0.0;
            this.m_gridBag.gridheight = 1;
            this.m_gridBag.gridwidth = 1;
            this.add((Component)new JLabel(VWResource.s_beforeDeadline), this.m_gridBag);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void enableControls(boolean bEnable) {
        try {
            this.m_deadlineUnitCBox.setEnabled(bEnable);
            this.m_deadlineTextField.setEnabled(bEnable);
            this.m_reminderTextField.setEnabled(bEnable);
            this.m_reminderUnitCBox.setEnabled(bEnable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setSelectedStep(VWStepDefinition stepDefinition) {
        long deadline = 0L;
        long reminder = 0L;
        try {
            if (this.m_stepDefinition != null && this.m_stepDefinition == stepDefinition) {
                return;
            }
            this.m_stepDefinition = stepDefinition;
            if (this.m_stepDefinition == null) {
                this.enableControls(false);
            } else if (this.m_stepDefinition.getStepId() == 0) {
                this.m_stepDefinition.setDeadline(0L);
                this.m_stepDefinition.setReminder(0L);
                this.enableControls(false);
            } else {
                deadline = this.m_stepDefinition.getDeadline();
                reminder = this.m_stepDefinition.getReminder();
                this.enableControls(true);
            }
            this.updateControls(deadline, reminder);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateControls(long deadline, long reminder) {
        try {
            VWTime deadlineTime = new VWTime(deadline, 0);
            VWTime reminderTime = new VWTime(reminder, 0);
            if (deadline != 0L) {
                if (!(deadlineTime.convertTime(3) || deadlineTime.convertTime(2) || deadlineTime.convertTime(1))) {
                    deadlineTime.convertTime(0);
                }
            } else {
                deadlineTime.convertTime(0);
            }
            this.m_deadlineTextField.getDocument().removeDocumentListener(this);
            this.m_deadlineUnitCBox.removeActionListener(this);
            this.m_deadlineTextField.setText(deadlineTime.getTime() + "");
            this.m_deadlineUnitCBox.setSelectedIndex(deadlineTime.getUnit());
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            this.m_deadlineUnitCBox.addActionListener(this);
            if (reminder != 0L) {
                if (!(reminderTime.convertTime(3) || reminderTime.convertTime(2) || reminderTime.convertTime(1))) {
                    reminderTime.convertTime(0);
                }
            } else {
                reminderTime.convertTime(0);
            }
            this.m_reminderTextField.getDocument().removeDocumentListener(this);
            this.m_reminderUnitCBox.removeActionListener(this);
            this.m_reminderTextField.setText(reminderTime.getTime() + "");
            this.m_reminderUnitCBox.setSelectedIndex(reminderTime.getUnit());
            this.m_reminderTextField.getDocument().addDocumentListener(this);
            this.m_reminderUnitCBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setWorkflow() {
        long deadline = 0L;
        long reminder = 0L;
        try {
            this.enableControls(false);
            if (this.m_authPropertyData != null) {
                this.m_workflowDefinition = this.m_authPropertyData.getWorkflowDefinition();
                if (this.m_workflowDefinition != null) {
                    deadline = this.m_workflowDefinition.getDeadline();
                    reminder = this.m_workflowDefinition.getReminder();
                    this.enableControls(true);
                }
            }
            this.updateControls(deadline, reminder);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateDeadlineDefinition() {
        try {
            String deadlineString = this.m_deadlineTextField.getText();
            if (deadlineString.length() == 0) {
                deadlineString = "0";
            }
            Long deadline = new Long(deadlineString.trim());
            int deadlineUnit = this.m_deadlineUnitCBox.getSelectedIndex();
            VWTime timeDeadline = new VWTime(deadline, deadlineUnit);
            timeDeadline.convertTime(0);
            if (this.m_mode == 1) {
                this.m_stepDefinition.setDeadline(timeDeadline.getTime());
            } else {
                this.m_workflowDefinition.setDeadline(timeDeadline.getTime());
            }
            this.m_authPropertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateReminderDefinition() {
        try {
            String reminderString = this.m_reminderTextField.getText();
            if (reminderString.length() == 0) {
                reminderString = "0";
            }
            Long reminder = new Long(reminderString.trim());
            int reminderUnit = this.m_reminderUnitCBox.getSelectedIndex();
            VWTime timeReminder = new VWTime(reminder, reminderUnit);
            timeReminder.convertTime(0);
            if (this.m_mode == 1) {
                this.m_stepDefinition.setReminder(timeReminder.getTime());
            } else {
                this.m_workflowDefinition.setReminder(timeReminder.getTime());
            }
            this.m_authPropertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

